#ifndef _DESS_SAVE_H
#define _DESS_SAVE_H

#include <desstypes.h>
#include <map>
#include <TileMap.h>
#include <Player.h>
#include <Hash.h>

#define SAVE_PATH_LENGTH 16
#define SAVE_FLAG_ENDING "ending"
#define SAVE_FLAG_NEWGAMEPLUS "newgame+"

struct SaveMapData
{
    HashInt hash = 0;
    u8 flags[MAP_FLAG_COUNT];
};

struct SaveData
{
    HashInt map = 0;
    HashInt prevMap = 0;
    ActorInventory inventory;
    std::vector<SaveMapData> mapData;
    std::vector<u16> flags;
    u8 position[2] = { 0, 0 };
    HashInt saveMap = 0;
    u32 time = 0;
    u16 deaths = 0;
};

class Save
{
private:
    static u8 slot;
    static SaveData data;

public:
    static void SetMap(const char * map, u8 * flags);
    static void SetMapCurrent(const char * map);
    static void SetMapPrevious(const char * map);
    static void GetMap(const char * map, u8 * out_flags);
    static void FlagSet(const char * flagName, bool on);
    static void FlagSet(HashInt hash, bool on);
    static bool FlagIsSet(const char * flagName);
    static bool FlagIsSet(HashInt hash);
    static void SetInventory(ActorInventory * inventory);
    static void GetInventory(ActorInventory * inventory);
    static void SetPosition(u8 x, u8 z);
    static void GetPosition(u8 * out_x, u8 * out_z);
    static void SetSlot(u8 slot);
    static void SetSpawnPoint(const char * areaName);
    static void SetSpawnPoint(HashInt hash);
    static void SetSaveMap(HashInt hash);
    static HashInt GetSaveMap();
    static void SetSeconds(u32 seconds);
    static u32 GetSeconds();
    static void AddDeath();
    static u16 GetDeaths();
    static u8 GetSlot();
    static void Clear();
    static void LoadFile();
    static void LoadFile(const char * path);
    static void SaveFile();
    static std::string GetSavePath();
    static const SaveData * GetData() { return &data; }
};

#endif