#include <Save.h>
#include <Hash.h>
#include <string>
#include <fstream>
#include <iostream>
#include <desslibs.h>
#include <FileSystem.h>

u8 Save::slot = 0;
SaveData Save::data;

void Save::SetMap(const char * mapName, u8 * flags)
{
    HashInt mapHash = Hash(mapName);
    if (mapHash != data.map)
    {
        data.prevMap = data.map;
    }
    data.map = mapHash;
    SaveMapData * mapData = NULL;
    for (std::vector<SaveMapData>::iterator it = data.mapData.begin(); it != data.mapData.end(); ++it)
    {
        if (it->hash == data.map)
        {
            mapData = &(*it);
            break;
        }
    }
    if (mapData == NULL)
    {
        data.mapData.push_back(SaveMapData());
        mapData = &data.mapData.back();
    }
    mapData->hash = data.map;
    memcpy(&mapData->flags, flags, sizeof(u8) * MAP_FLAG_COUNT);
}

void Save::SetMapCurrent(const char * mapName)
{   
    HashInt mapHash = Hash(mapName);
    data.map = mapHash;
}

void Save::SetMapPrevious(const char * mapName)
{
    HashInt mapHash = Hash(mapName);
    data.prevMap = mapHash;
}

void Save::GetMap(const char * mapName, u8 * out_flags)
{
    HashInt hash = Hash(mapName);
    for (std::vector<SaveMapData>::iterator it = data.mapData.begin(); it != data.mapData.end(); ++it)
    {
        if (it->hash == hash)
        {
            memcpy(out_flags, &it->flags, sizeof(u8) * MAP_FLAG_COUNT);
            break;
        }
    }
}

void Save::SetInventory(ActorInventory * inventory)
{
    memcpy(&data.inventory, inventory, sizeof(ActorInventory));
}

void Save::GetInventory(ActorInventory * inventory)
{
    if (data.inventory.hearts < 1)
    {
        data.inventory.hearts = PLAYER_DEFAULT_HEARTS;
    }
    memcpy(inventory, &data.inventory, sizeof(ActorInventory));
}

void Save::SetPosition(u8 x, u8 z)
{
    data.position[0] = x;
    data.position[1] = z;
}

void Save::GetPosition(u8 * out_x, u8 * out_z)
{
    *out_x = data.position[0];
    *out_z = data.position[1];
}

bool Save::FlagIsSet(const char * flagName)
{
    HashInt hash = Hash(flagName);
    return FlagIsSet(hash);
}

bool Save::FlagIsSet(HashInt hash)
{
    for (std::vector<HashInt>::iterator it = data.flags.begin(); it != data.flags.end(); ++it)
    {
        if (*it == hash)
            return true;
    }
    return false;
}

void Save::FlagSet(const char * flagName, bool on)
{
    HashInt hash = Hash(flagName);
    FlagSet(hash, on);
}

void Save::FlagSet(HashInt hash, bool on)
{
    if (on)
    {
        if (FlagIsSet(hash))
            return;
        data.flags.push_back(hash);
    }
    else
    {
        if (FlagIsSet(hash) == false)
            return;

        for (std::vector<HashInt>::iterator it = data.flags.begin(); it != data.flags.end();)
        {
            if (*it == hash)
            {
                data.flags.erase(it);
                break;
            }
            else
            {
                it++;
            }
        }
    }
}

void Save::SetSpawnPoint(const char * name)
{
    SetSpawnPoint(Hash(name));
}

void Save::SetSpawnPoint(HashInt hash)
{
    data.prevMap = hash;
    SaveFile();
}


void Save::SetSaveMap(HashInt hash)
{
    data.saveMap = hash;
}

void Save::SetSeconds(u32 seconds)
{
    data.time = seconds;
}

u32 Save::GetSeconds()
{
    return data.time;
}

void Save::AddDeath()
{
    data.deaths++;
}

u16 Save::GetDeaths()
{
    return data.deaths;
}

HashInt Save::GetSaveMap()
{
    return data.saveMap;
}

void Save::SetSlot(u8 _slot)
{
    slot = _slot;
}

u8 Save::GetSlot()
{
    return slot;
}

void Save::Clear()
{
    data.map = 0;
    data.prevMap = 0;
    data.mapData.clear();
    data.flags.clear();
    data.saveMap = 0;
    data.time = 0;
    data.deaths = 0;
    memcpy(&data.inventory, new ActorInventory(), sizeof(ActorInventory));
}

void Save::LoadFile()
{
    std::string savePath = GetSavePath();
    LoadFile(savePath.c_str());
}

void Save::LoadFile(const char * path)
{
    Log_Info("Loading save from %s...\n", path);
    Clear();
    SDL_RWops * file = FileSystem::FileOpen(path, "r+b" );
    if (file == NULL)
        return;

    // 1. map
    if (FileSystem::FileRead(file, &data.map, sizeof(HashInt), 1) == 0)
        return;

    if (FileSystem::FileRead(file, &data.prevMap, sizeof(HashInt), 1) == 0)
        return;

    // 2. map data
    u16 mapCount = 0;
    if (FileSystem::FileRead(file, &mapCount, sizeof(u16), 1) == 0)
        return;
    data.mapData.clear();
    for (u16 i=0; i<mapCount; i++)
    {
        SaveMapData mapData;
        if (FileSystem::FileRead(file, &mapData, sizeof(SaveMapData), 1) == 0)
            return;
        data.mapData.push_back(mapData);
    }

    // 3. flags
    u16 flagCount = 0;
    if (FileSystem::FileRead(file, &flagCount, sizeof(u16), 1) == 0)
        return;
    for (u16 i=0; i<flagCount; i++)
    {
        HashInt flag;
        if (FileSystem::FileRead(file, &flag, sizeof(HashInt), 1) == 0)
            return;
        if (FlagIsSet(flag) == false)
        {
            data.flags.push_back(flag);
        }
    }

    // 4. inventory
    if (FileSystem::FileRead(file, &data.inventory, sizeof(ActorInventory), 1) == 0)
        return;

    // 5. position
    if (FileSystem::FileRead(file, &data.position[0], sizeof(u8), 2) == 0)
        return;

    // 6. savemap
    if (FileSystem::FileRead(file, &data.saveMap, sizeof(HashInt), 1) == 0)
        return;

    // 7. time
    if (FileSystem::FileRead(file, &data.time, sizeof(u32), 1) == 0)
        return;

    // 8. deaths
    if (FileSystem::FileRead(file, &data.deaths, sizeof(u16), 1) == 0)
        return;

    SDL_RWclose(file);
}

void Save::SaveFile()
{
    std::string savePath = GetSavePath();
    Log_Info("Saving game to %s...\n", savePath.c_str());
    SDL_RWops * file = FileSystem::FileOpen(savePath.c_str(), "w+b");

    if (file == NULL)
    {
        Log_Error( "Error: Unable to save file! %s\n", SDL_GetError());
        return;
    }

    // 1. map
    if (FileSystem::FileWrite(file, &data.map, sizeof(HashInt), 1) == 0)
        return;
    if (FileSystem::FileWrite(file, &data.prevMap, sizeof(HashInt), 1) == 0)
        return;

    // 2. map data
    u16 mapCount = data.mapData.size();
    if (FileSystem::FileWrite(file, &mapCount, sizeof(u16), 1) == 0)
        return;
    for (u16 i=0; i<mapCount; i++)
    {
        if (FileSystem::FileWrite(file, &data.mapData[i], sizeof(SaveMapData), 1) == 0)
            return;
    }

    // 3. flags
    u16 flagCount = data.flags.size();
    if (FileSystem::FileWrite(file, &flagCount, sizeof(u16), 1) == 0)
        return;
    for (u16 i=0; i<flagCount; i++)
    {
        if (FileSystem::FileWrite(file, &data.flags[i], sizeof(HashInt), 1) == 0)
            return;
    }

    // 4. inventory
    if (FileSystem::FileWrite(file, &data.inventory, sizeof(ActorInventory), 1) == 0)
        return;

    // 5. position
    if (FileSystem::FileWrite(file, &data.position[0], sizeof(u8), 2) == 0)
        return;

    // 6. savemap
    if (FileSystem::FileWrite(file, &data.saveMap, sizeof(HashInt), 1) == 0)
        return;

    // 7. time
    if (FileSystem::FileWrite(file, &data.time, sizeof(u32), 1) == 0)
        return;
    
    // 8. deaths
    if (FileSystem::FileWrite(file, &data.deaths, sizeof(u16), 1) == 0)
        return;

    FileSystem::FileClose(file);
}

std::string Save::GetSavePath()
{
    char savePath[16];
    sprintf(savePath, "Save_%d.sav\0", slot + 1);
    return FileSystem::GetAbsolutePath(savePath);
}
