#ifndef _PLAYER_H
#define _PLAYER_H

#include <desstypes.h>
#include <Actor.h>

class TileMap;
struct MapObject;
class MapSequence;
class PropCupboard;

#define PLAYER_DEFAULT_HEARTS 4

class Player : public Actor
{
private:
    Vector2 input = Vector2_ZERO;
    const MapObject * enterArea = NULL;
    const MapObject * insideArea = NULL;
    const MapObject * promptObject = NULL;
    float promptTime = 0.0f;
    MapPoint areaPoint = MapPoint_MIN;
    Vector3 areaEnterPos = Vector3_ZERO;
    Direction spawnWalkDir = Direction_None;
    Vector3 prevPos = Vector3_ZERO;
    bool oddStep = false;
    PropCupboard * inCupboard = NULL;
    MapPoint groundSafePoint = MapPoint_MIN;
    MapPoint groundSafePointCandidate = MapPoint_MIN;

public:
    char wantMap[MAP_NAME_LENGTH];
    u8 exitOffset[2] = { 0, 0 };

    Player();
    virtual ~Player();

    void Start();
    void LoadModel();

    void Spawn(Vector3 position);
    void Spawn(Vector3 position, Direction walkDir);
    void Respawn();

    void Update(float dt);
    Vector3 GetMoveVelocity(float dt);
    
    void OutOfMap();
    void OnCollision(Entity * other);
    void GotoMap(const MapObject * obj);
    
    void Strike();
    void OnStrike(MapEntity * other, u8 power);

    void SetHoldItem(MapEntityType entityType);
    void SetHoldItemAnnounced(MapEntityType holdItem);

    bool TakeHit(Entity * other, u8 power);

    void OnDead();

private:
    void SetPrompt(const char * text, const MapObject * obj);
    void UsePrompt(const MapObject * obj);
    void WalkIn();
};

#endif