#ifndef _PARTY_H
#define _PARTY_H

#include <desslist.h>
#include <MapEntityFactory.h>

class NPCActor;
class TileMap;

class Party
{
public:
    static Party & Inst();
    static HashInt ToSaveFlag(MapEntityType memberType);
    static bool IsMemberInParty(MapEntityType memberType);

private:
    MapEntityFactory factory;
    Entity * host = NULL;
    TileMap * currentMap = NULL;
    std::vector<NPCActor*> members;

    Party() {}

public:
    
    void SetHost(Entity * entity);
    void Load(TileMap * scene);
    void Unload();
    bool AddPartyMember(MapEntityType memberType);
    bool AddPartyMember(NPCActor * member);
    bool RemovePartyMember(MapEntityType memberType);
    u8 GetMemberIndex(MapEntityType memberType) const;
};

#endif