#ifndef _MISSIONS_H
#define _MISSIONS_H

#include <dessint.h>
#include <desslist.h>
#include <MapData.h>

enum MissionState
{
    MissionState_NONE,
    MissionState_INCOMPLETE,
    MissionState_COMPLETE
};

struct Mission
{
    HashInt hash;
    char name[MAP_NAME_LENGTH];
    char text[MAP_MESSAGE_LENGTH];
    char sound[MAP_PATH_LENGTH];
};

#define GameProgress_COIN_COUNT 8
#define GameProgress_MISSION_COUNT 12

struct GameProgress
{
    u16 time = 0;
    u8 percent = 0;
    u16 deaths = 0;
    bool missions[GameProgress_MISSION_COUNT];
    bool coins[GameProgress_COIN_COUNT];
};

class Missions
{
private:
    std::vector<Mission> missions;
    bool hasLoaded = false;

    Missions(){}
public:
    static Missions & Inst();

    void Load();
    void Complete(const char * missionId);
    MissionState GetState(const char * missionId);
    GameProgress GetProgress() const;
};

#endif