#ifndef _CMD_RUNNER_H
#define _CMD_RUNNER_H

#include <dessint.h>
#include <desslist.h>
#include <Sequencer.h>
#include <ui/GameUI.h>

struct MapObject;
struct MapCmd;
class TileMap;
class Actor;
class Player;
class ActorBehaviour;

class MapSequence : public Sequence
{
private:
    const MapObject * host = NULL;
    const MapObject * currentObj = NULL;
    const MapObject * actorObj = NULL;
    TileMap * map = NULL;
    u8 cmdIndex = 0;
    u8 stackSize = 0;
    ActorBehaviour * waitForBehaviour = NULL;
    bool gameBeaten = false;
    
public:
    MapSequence(TileMap * map, const MapObject * obj);

    void Run();
    SequenceState RunNext(const MapObject * obj);
    void Stop();
    void Resume();
    bool CanContinue();
    Entity * GetTarget() const;

    const MapObject * GetCurrentObj() const;
    const MapCmd * GetCurrentCmd() const;

    static void SaveCmd(const char * save);

private:
    bool DoSay(const MapObject * obj, const MapCmd * cmd, MessageType messageType);
    bool CheckIf(const MapCmd * cmd, bool positiveValue);
    const MapObject * GetNext(const MapCmd * cmd);
    Player * GetActivePlayer();
};

#endif