#ifndef _MAP_ENVIRONMENT_H
#define _MAP_ENVIRONMENT_H

#include <dessint.h>
#include <desslist.h>
#include <MapData.h>

struct MapLayerInfo
{
    HashInt hash;
    MapPath textureSurface;
    MapPath textureEdge;
    MapPath textureTree;
    MapPath shader;
    float slip = 0.0f;
    u8 damage = 0;
    MapLayerInfo() : textureSurface(NULL), textureEdge(NULL), textureTree(NULL), shader(NULL) {}
};

struct MapEnvInfo 
{
    HashInt hash;
    u8 border = 0;
    const MapLayerInfo * layers[MAP_LAYER_COUNT];
    char music[MAP_NAME_LENGTH];
};

class MapEnvironment
{
private:
    static bool hasLoaded;
    static std::vector<MapEnvInfo> envs;
    static std::vector<MapLayerInfo> layers;

public:
    static const MapEnvInfo * GetEnvInfo(HashInt hash);

    static const MapEnvInfo * GetEnvInfo(const char * name);

    static const MapLayerInfo * GetLayerInfo(HashInt hash);

    static const MapLayerInfo * GetLayerInfo(const char * name);
    
    static void MarkUnloaded();
    static void Load();
};



#endif