#ifndef _MAP_ENTITY_TYPES_H
#define _MAP_ENTITY_TYPES_H

#include <dessint.h>
#include <MapData.h>

enum MapEntityType {
    MapEntityType_None,
    MapEntityType_Player,
    MapEntityType_Crate,
    MapEntityType_Tree,
    MapEntityType_Switch,
    MapEntityType_BlockLower,
    MapEntityType_BlockRaise,
    MapEntityType_LockDoor,
    MapEntityType_Boulder,
    MapEntityType_Hut,
    MapEntityType_Table,
    MapEntityType_Shelf,
    MapEntityType_Cupboard,
    MapEntityType_Bench,
    MapEntityType_Bed,
    MapEntityType_Note,
    MapEntityType_Door,
    MapEntityType_Gate,
    MapEntityType_Sign,
    MapEntityType_Bridge,
    MapEntityType_Obelisk,
    MapEntityType_Grass,
    MapEntityType_SaveSwitch,
    MapEntityType_MusicNote,
    MapEntityType_EmptySlot,
    MapEntityType_BlackGate,
    MapEntityType_Townee = 26,
    MapEntityType_Oracle,
    MapEntityType_Timsmith,
    MapEntityType_Woodsmith,
    MapEntityType_Locksmith,
    MapEntityType_Temptress,
    MapEntityType_Chicken = 34,
    MapEntityType_Heart,
    MapEntityType_HeartPiece,
    MapEntityType_DragonCoin,
    MapEntityType_Key = 42,
    MapEntityType_Sword,
    MapEntityType_Axe,
    MapEntityType_SwordFire,
    MapEntityType_SwordElectric,
    MapEntityType_SwordIce,
    MapEntityType_SwordParticulars,
    MapEntityType_Chook = 50,
    MapEntityType_Chook2,
    MapEntityType_Chook3,
    MapEntityType_Ogre,
    MapEntityType_Minion,
    MapEntityType_FireWizard,
    MapEntityType_Blacklordoron,
    MapEntityType_LavaBall = 58,
    MapEntityType_Model,
    MapEntityType_MAX
};

#define MapEntityType_SwordMin MapEntityType_Key
#define MapEntityType_SwordMax MapEntityType_SwordParticulars
#define MapEntityType_PickupMin MapEntityType_Chicken
#define MapEntityType_PickupMax MapEntityType_SwordMax
#define MapEntityType_NPCMin MapEntityType_Townee
#define MapEntityType_NPCMax MapEntityType_Temptress
#define MapEntityType_DoorMin MapEntityType_Door
#define MapEntityType_DoorMax MapEntityType_Gate
#define MapEntityType_BaddieMin MapEntityType_Chook
#define MapEntityType_BaddieMax MapEntityType_Blacklordoron

#define MAP_ENTITY_TYPE_OFFSET 2

class MapEntityTypes
{
public:

    static MapEntityType ToType(u16 entityId)
    {
        return (MapEntityType)(entityId + MAP_ENTITY_TYPE_OFFSET);
    }

    static u16 ToId(MapEntityType type)
    {
        return (u16)type - MAP_ENTITY_TYPE_OFFSET;
    }

    static bool IsPickup(MapEntityType type)
    {
        return type >= MapEntityType_PickupMin && type <= MapEntityType_PickupMax;
    }

    static bool IsSword(MapEntityType type)
    {
        return type >= MapEntityType_SwordMin && type <= MapEntityType_SwordMax;
    }

    static bool IsDoor(MapEntityType type)
    {
        if (type == MapEntityType_LockDoor)
            return true;
        return type >= MapEntityType_DoorMin && type <= MapEntityType_DoorMax || type == MapEntityType_BlackGate;
    }

    static bool IsDoor(const MapObject * obj)
    {
        return obj != NULL && obj->entity != NULL && IsDoor(ToType(obj->type));
    }

    static bool IsNPC(MapEntityType type)
    { 
        return type >= MapEntityType_NPCMin && type <= MapEntityType_NPCMax;
    }

    static bool IsBaddie(MapEntityType type)
    {
        return type >= MapEntityType_BaddieMin && type <= MapEntityType_BaddieMax;
    }

    static bool IsActor(MapEntityType type)
    {
        return IsNPC(type) || IsBaddie(type) || type == MapEntityType_Player;
    }

    static bool IsActor(const MapObject * obj)
    {
        return obj != NULL && obj->entity != NULL && IsActor(ToType(obj->type));
    }

    static bool IsActorOrPlayer(MapEntityType type)
    {
        return type == MapEntityType_Player || IsNPC(type) || IsBaddie(type);
    }

    static bool IsPushable(MapEntityType type)
    {
        switch (type)
        {
            case MapEntityType_Boulder:
            case MapEntityType_Crate:
                return true;
        }
        return false;
    }

    static bool IsFlammable(MapEntityType type)
    {
        switch (type)
        {
            case MapEntityType_Crate:
            case MapEntityType_Table:
            case MapEntityType_Shelf:
            case MapEntityType_Cupboard:
            case MapEntityType_Bench:
            case MapEntityType_Bed:
            case MapEntityType_Note:
            case MapEntityType_Gate:
                return true;
        }
        return false;
    }

    static const char * GetSwordName(MapEntityType type)
    {
        switch (type)
        {
            case MapEntityType_Axe:
                return "Chopping";

            case MapEntityType_Key:
                return "Unlocking";

            case MapEntityType_Sword:
                return "Unspoken Misc";

            case MapEntityType_SwordFire:
                return "Fury";

            case MapEntityType_SwordElectric:
                return "Power";

            case MapEntityType_SwordIce:
                return "Inverted Fury";

            case MapEntityType_SwordParticulars:
                return "Particulars";
        }
        return "?";
    }

    static u8 GetSwordPower(MapEntityType type)
    {
        switch (type)
        {
            case MapEntityType_Axe:
                return 2;

            case MapEntityType_Key:
            case MapEntityType_Sword:
                return 1;

        }
        return 0;
    }
};

#endif