#include <MapEntityFactory.h>
#include <MapEntity.h>
#include <props/PropCrate.h>
#include <props/PropTree.h>
#include <props/PropSwitch.h>
#include <props/PropSaveSwitch.h>
#include <props/PropBlockRaiseLower.h>
#include <props/PickupKey.h>
#include <props/PickupDragonCoin.h>
#include <props/PropLockDoor.h>
#include <props/PropBoulder.h>
#include <props/PropHut.h>
#include <props/PropTable.h>
#include <props/PropShelf.h>
#include <props/PropBench.h>
#include <props/PropCupboard.h>
#include <props/PropBed.h>
#include <props/PropDoor.h>
#include <props/PropGate.h>
#include <props/PropBlackGate.h>
#include <props/PropSign.h>
#include <props/PropBridge.h>
#include <props/PropObelisk.h>
#include <props/PropGrass.h>
#include <props/PropLavaBall.h>
#include <actors/NPCTownee.h>
#include <actors/NPCOracle.h>
#include <actors/NPCTimsmith.h>
#include <actors/NPCWoodsmith.h>
#include <actors/NPCLocksmith.h>
#include <actors/NPCTimsmith.h>
#include <actors/NPCTemptress.h>
#include <actors/ActorChook.h>
#include <actors/ActorChook2.h>
#include <actors/ActorChook3.h>
#include <actors/ActorOgre.h>
#include <actors/ActorMinion.h>
#include <actors/ActorFireWizard.h>
#include <actors/ActorBlacklordoron.h>
#include <props/PickupSword.h>
#include <props/PickupAxe.h>
#include <props/PickupSwordFire.h>
#include <props/PickupSwordIce.h>
#include <props/PickupSwordElectric.h>
#include <props/PickupDress.h>
#include <props/ModelProp.h>

bool MapEntityFactory::CanCreate(u16 entityId)
{
    MapEntityType type = MapEntityTypes::ToType(entityId);
    return type < MapEntityType_MAX;
}

MapEntity * MapEntityFactory::CreateId(u16 entityId)
{
    MapEntityType type = MapEntityTypes::ToType(entityId);
    return Create(type);
}

MapEntity * MapEntityFactory::Create(MapEntityType type)
{
    switch (type)
    {
        case MapEntityType_Crate:
            return new PropCrate();

        case MapEntityType_Tree:
            return new PropTree();

        case MapEntityType_Switch:
            return new PropSwitch();

        case MapEntityType_SaveSwitch:
            return new PropSaveSwitch();

        case MapEntityType_BlockLower:
            return new PropBlockLower();

        case MapEntityType_BlockRaise:
            return new PropBlockRaise();

        case MapEntityType_LockDoor:
            return new PropLockDoor();

        case MapEntityType_Boulder:
            return new PropBoulder();
            
        case MapEntityType_Hut:
            return new PropHut();

        case MapEntityType_Table:
            return new PropTable();

        case MapEntityType_Shelf:
            return new PropShelf();

        case MapEntityType_Bench:
            return new PropBench();

        case MapEntityType_Cupboard:
            return new PropCupboard();

        case MapEntityType_Bed:
            return new PropBed();

        case MapEntityType_Door:
            return new PropDoor();

        case MapEntityType_Gate:
            return new PropGate();

        case MapEntityType_BlackGate:
            return new PropBlackGate();

        case MapEntityType_Sign:
            return new PropSign();

        case MapEntityType_Bridge:
            return new PropBridge();

        case MapEntityType_Obelisk:
            return new PropObelisk();

        case MapEntityType_LavaBall:
            return new PropLavaBall();

        case MapEntityType_Grass:
            return new PropGrass();

        case MapEntityType_Townee:
            return new NPCTownee();

        case MapEntityType_Oracle:
            return new NPCOracle();
            
        case MapEntityType_Timsmith:
            return new NPCTimsmith();
            
        case MapEntityType_Woodsmith:
            return new NPCWoodsmith();

        case MapEntityType_Locksmith:
            return new NPCLocksmith();

        case MapEntityType_Temptress:
            return new NPCTemptress();

        case MapEntityType_Chook:
            return new ActorChook();
        
        case MapEntityType_Chook2:
            return new ActorChook2();

        case MapEntityType_Chook3:
            return new ActorChook3();

        case MapEntityType_Ogre:
            return new ActorOgre();

        case MapEntityType_Minion:
            return new ActorMinion();

        case MapEntityType_FireWizard:
            return new ActorFireWizard();
            
        case MapEntityType_Blacklordoron:
            return new ActorBlacklordoron();

        case MapEntityType_Key:
            return new PickupKey();

        case MapEntityType_DragonCoin:
            return new PickupDragonCoin();
            
        case MapEntityType_Sword:
            return new PickupSword();

        case MapEntityType_Axe:
            return new PickupAxe();

        case MapEntityType_SwordFire:
            return new PickupSwordFire();

        case MapEntityType_SwordIce:
            return new PickupSwordIce();

        case MapEntityType_SwordElectric:
            return new PickupSwordElectric();

        case MapEntityType_SwordParticulars:
            return new PickupDress();

        case MapEntityType_Model:
            return new ModelProp();
    }
    return NULL;
}