#ifndef _MAP_ENTITY_H
#define _MAP_ENTITY_H

#include <Entity.h>
#include <Collider.h>
#include <TileMap.h>
#include <MapEntityTypes.h>

#define MapEntity_KNOCK_TIME 0.5f
#define MapEntity_DEFAULT_GRADIENT 0.5f
#define MapEntity_KNOCKOUT_Y -10.0f
#define MapEntity_DEFAULT_WATER_HEIGHT MapEntity_KNOCKOUT_Y

struct MapLayerInfo;

class MapEntity : public Entity
{
public:
    MapEntityType type;

protected:
    Vector3 spawnPos = Vector3_ZERO;
    bool hasSpawned = false;
    Quat spawnRot = Quat_IDENTITY;
    Vector3 velocity = Vector3_ZERO;
    Vector3 moveVelocity = Vector3_ZERO;
    Vector3 slipVelocity = Vector3_ZERO;
    Vector3 dirMove = Vector3_ZERO;
    Vector3 dirCollision = Vector3_ZERO;
    bool isMoving = false;
    bool isGrounded = false;
    float fall = 0.0f;
    float groundY = 0.0f;
    float acceleration = 1.0f;
    float deceleration = 0.3f;
    float maxGradient = MapEntity_DEFAULT_GRADIENT;
    float waterHeight = MapEntity_DEFAULT_WATER_HEIGHT;
    bool useGravity = true;
    bool canDespawn = true;
    float knockTime = 0.0f;
    float knockPower = 0.0f;
    MapPoint point;
    TileInfo mapTile;
    u8 layer = 0;
    const MapLayerInfo * layerInfo = NULL;
    u8 damage = 0;

public:
    const MapObject * info = NULL;
    float radius = 0.5f;
    TileMap * map = NULL;

    MapEntity(MapEntityType type);
    virtual ~MapEntity();

    virtual void Added();
    virtual void Start();
    virtual void Reset();
    virtual void Update(float dt);
    virtual void Render() = 0;
    virtual void Spawn(Vector3 position);
    virtual void Respawn();
    virtual bool TakeHit(Entity * other, u8 power);
    virtual void Knock(Vector3 direction);
    virtual void Knock(Entity * other);

    void SetCollision(CollisionMode mode, Vector3 size = Vector3_ZERO, Vector3 center = Vector3_ZERO);
    void SetMaxGradient(float value = MapEntity_DEFAULT_GRADIENT)
    {
        maxGradient = value;
    }

    inline Vector3 GetSpawnPos() const { return spawnPos; }

    inline MapEntityType GetType() const { return type; }
    inline Vector3 GetDir() const { return dirMove; }
    inline u8 GetDamage() const { return damage; }

    virtual void OnCollision(Entity* other);

protected:
    virtual Vector3 GetMoveVelocity(float dt);
    virtual void UpdateAnimation(float dt) {}
    virtual void OutOfMap();
};

#endif
