#include <MapData.h>
#include <Hash.h>
#include <FileSystem.h>
#include <string.h>

const char * MapStr::ReadText(const MapStr * mapStr, const char * defaultValue)
{
    if (mapStr == NULL)
        return defaultValue;
    const char * result = mapStr->Text();
    if (result == NULL || result[0] == '\0')
        return defaultValue;
    return result;
}

bool MapStr::IsValid(const MapStr * mapStr)
{
    if (mapStr == NULL)
        return false;
    const char* text = mapStr->Text();
    return text != NULL && text[0] != '\0';
}

MapStr::MapStr(const char * src, u16 _length)
{
    if (src != NULL && src[0] != '\0')
    {
        length = _length;
        text = new char[length];
        strncpy(text, src, length);
        text[length - 1] = '\0';
    }
    else
    {
        length = 0;
        text = NULL;
    }
}

MapStr::MapStr(const MapStr & original)
{
    if (original.length < 1 || original.text == NULL)
    {
        text = NULL;
        length = 0;
    }
    else
    {
        length = original.length;
        text = new char[length];
        strncpy(text, original.text, length);
    }
}

MapStr& MapStr::operator=(const MapStr& original)
{
    if (original.length < 1 || original.text == NULL)
    {
        text = NULL;
        length = 0;
    }
    else
    {
        length = original.length;
        text = new char[length];
        strncpy(text, original.text, length);
    }
    return *this;
}

MapStr::~MapStr()
{
    if (text != NULL && length > 0)
    {
        delete[] text;
        length = 0;
    }
}

MapObject MapObject::BLANK;

void MapObject::Constrain(i16 & px, i16 & pz) const
{
    if (px < x)
    {
        px = x;
    }
    else if (px > x + width - 1)
    {
        px = x + width - 1;
    }
    if (pz < z)
    {
        pz = z;
    }
    else if (pz > z + depth - 1)
    {
        pz = z + depth - 1;
    }
}

std::string MapUtils::MapPathToName(const char * mapPath)
{
    return FileSystem::GetBaseName(mapPath);
}

HashInt MapUtils::MapPathToHash(const char * mapPath)
{
    return Hash(MapPathToName(mapPath).c_str());
}

std::string MapUtils::MapHashToPath(HashInt hash)
{
    DirScan dir = FileSystem::DirOpen("maps");
    while (const char * filename = FileSystem::DirRead(dir))
    {
        if (hash == MapPathToHash(filename))
        {
            char * result = new char[64];
            sprintf(result, "maps/%s", filename);
            return result;
        }
    }
    return NULL;
}