#ifndef _DIRECTION_H
#define _DIRECTION_H

#include <dessint.h>

enum Direction
{
    Direction_None,
    Direction_North,
    Direction_East,
    Direction_South,
    Direction_West
};

class Directions
{
public:
    static i16 GetX(const Direction dir)
    {
        switch(dir)
        {
            case Direction_East:
                return 1;
            case Direction_West:
                return -1;
        } 
        return 0;
    }
        
    static i16 GetZ(const Direction dir)
    {
        switch(dir)
        {
            case Direction_North:
                return -1;
            case Direction_South:
                return 1;
        } 
        return 0;
    }

    static Vector3 GetForward(const Direction direction)
    {
        switch (direction)
        {
            case Direction_North:
                return Vector3_NORTH;

            case Direction_East:
                return Vector3_EAST;

            case Direction_South:
                return Vector3_SOUTH;

            case Direction_West:
                return Vector3_WEST;
        }
        return Vector3_ZERO;
    }

    static Direction Opposite(const Direction direction)
    {
        switch (direction)
        {
            case Direction_North:
                return Direction_South;

            case Direction_East:
                return Direction_West;

            case Direction_South:
                return Direction_North;

            case Direction_West:
                return Direction_East;
        }
        return Direction_None;
    }

    static Direction Turn(const Direction direction, i8 turns)
    {
        return (Direction)(((INT8_MAX + turns + 1) % 4) - 1);
    }

    static void Move(const Direction direction, i16 * x, i16 * z, u8 spaces = 1)
    {
        *x += GetX(direction) * spaces;
        *z += GetZ(direction) * spaces;
    }
};

#endif