#ifndef _DEBUG_OVERLAY_H
#define _DEBUG_OVERLAY_H

#include <dessgeom.h>
#include <Material.h>
#include <Primatives.h>
#include <Mesh.h>

class SwordGameScene;
struct MapObject;
class Collider;
class TileMap;

class DebugOverlay
{
private:
    Mesh mesh;
    Material debugMaterial;
    float boxVerts[CUBE_VERTEX_COUNT];
    u32 boxTris[CUBE_INDEX_COUNT];
    Matrix mtx;
public:
    void Render(SwordGameScene * scene);
    void DrawCollider(Collider * collider);
    void DrawArea(TileMap * map, const MapObject * area);
    void DrawBox(Vector3 position, Vector3 size);
};

#endif