#include <desslibs.h>
#include "DebugOverlay.h"
#include "SwordGameScene.h"
#include <RenderWindow.h>
#include <Collider.h>
#include <MapData.h>

void DebugOverlay::Render(SwordGameScene * scene)
{
    debugMaterial.LoadShader("shaders/standard.dsh");
    for (EntityIt it = scene->EntitiesBegin(); it != scene->EntitiesEnd(); ++it)
    {
        Entity * entity = *it;
        if (entity->collider != NULL && entity->IsEnabled())
        {
            DrawCollider((Collider*)entity->collider);
            DrawBox(entity->transform.position + entity->transform.Forwards() + Vector3_UP, Vector3(0.2f));
        }
    }
    for (std::vector<MapObject>::iterator it = scene->map.data.areas.begin(); it != scene->map.data.areas.end(); ++it)
    {
        //DrawArea(&scene->map, &(*it));
    }
}

void DebugOverlay::DrawCollider(Collider * collider)
{
    const AABB & aabb = collider->GetAABB();
    DrawBox(aabb.pos, aabb.half * 2.0f);
}

void DebugOverlay::DrawArea(TileMap * map, const MapObject * area)
{
    Vector3 min = map->GetPosition(area->x, area->z);
    Vector3 max = map->GetPosition(area->x + area->width, area->z + area->depth);
    DrawBox((min + max) * 0.5f, Vector3(
        area->width * map->data.tileSize, 
        2.0f, 
        area->depth * map->data.tileSize
    ));
}

void DebugOverlay::DrawBox(Vector3 center, Vector3 size)
{
    Vector3 half = size * 0.5f;
    Primatives::Cube(size, center, &boxVerts[0], &boxTris[0]);
    RenderWindow * window = RenderWindow::Current();
    RenderMode prevMode = window->GetRenderMode();
    window->SetRenderMode(RenderMode_Wireframe);
    Matrix mtx(1.0f);
    window->RenderData(&boxVerts[0], sizeof(boxVerts), NULL, 0, NULL, 0, &boxTris[0], sizeof(boxTris), &debugMaterial, &mtx);
    window->SetRenderMode(prevMode);
}