#include "AttackManager.h"
#include "Actor.h"
#include <string>
#include <Scene.h>
#include <MapEntityTypes.h>

std::vector<Actor*> AttackManager::attackers;
bool AttackManager::isChilling = false;
bool AttackManager::isPaused = false;

void AttackManager::Add(Actor * attacker)
{
    if (attacker == NULL || attacker->IsEnabled() == false)
        return;
    
    for (std::vector<Actor*>::iterator it = attackers.begin(); it != attackers.end(); ++it)
    {
        if ((*it) == attacker)
            return;
    }
    attackers.push_back(attacker);
}

void AttackManager::Remove(Actor * attacker)
{
    for (std::vector<Actor*>::iterator it = attackers.begin(); it != attackers.end(); ++it)
    {
        if ((*it) == attacker)
        {
            attackers.erase(it);
            return;
        }
    }
}

void AttackManager::Chill()
{
    if (isChilling)
        return;
    isChilling = true;
    for (u8 i=0; i<attackers.size(); i++)
    {
        if (attackers[i]->IsEnabled() == false)
            continue;
        attackers[i]->Chill();
    }
    isChilling = false;
}

void AttackManager::Clear()
{
    attackers.clear();
}

u8 AttackManager::GetAttackerCount()
{
    u8 count = 0;
    for (u8 i=0; i<attackers.size(); i++)
    {
        if (attackers[i]->IsEnabled() == false)
            continue;
        if (attackers[i]->inventory.hearts > 0)
            count++;
    }
    return count;
}