#ifndef _DESS_IQM_READER_H
#define _DESS_IQM_READER_H

#include <desslibs.h>
#include "iqm.h"
#include "util.h"
#include "geom.h"
#include "ModelReader.h"

const float IQM_TIME_SCALE = 1.0f / 30.0f;

class IqmReader : public ModelReader
{
public:
    bool Load(const char * modelPath);
    void Clear();
    bool LoadAnimations(const char * animModelPath);
    void Process(Mesh * mesh, float * time, ModelAnimData * animA = NULL, ModelAnimData * animB = NULL, float blend = 0.0f) const;
    u16 GetFrameCount() const { return (u16)numframes; }

    IqmReader();
    virtual ~IqmReader();

private:
    bool LoadMeshData(const char *filename, const iqmheader &hdr, uchar *buf);
    bool LoadAnimData(const char *filename, const iqmheader &hdr, uchar *buf);
    void Animate(float curframe, ModelAnimData * animA, ModelAnimData * animB, float blend) const;
    void CleanUp();

    uchar *meshdata = NULL, *animdata = NULL;
    float *inposition = NULL, *innormal = NULL, *intangent = NULL, *intexcoord = NULL;
    uchar *inblendindex = NULL, *inblendweight = NULL, *incolor = NULL;
    float *outposition = NULL, *outnormal = NULL, *outtangent = NULL, *outbitangent = NULL, *blendposition = NULL, *blendnormal = NULL;
    int nummeshes = 0, numtris = 0, numverts = 0, numjoints = 0, numframes = 0, numanims = 0;
    iqmtriangle *tris = NULL, *adjacency = NULL;
    iqmmesh *meshes = NULL;
    u32 *textures = NULL;
    iqmjoint *joints = NULL;
    iqmpose *poses = NULL;
    iqmanim *anims = NULL;
    iqmbounds *bounds = NULL;
    iqmgeom::Matrix3x4 *baseframe = NULL, *inversebaseframe = NULL, *outframe = NULL, *frames = NULL;
    iqmheader hdr;
    void WriteVec3(iqmgeom::Vec3 * in, Vector3 * out) const;
    void WriteVerts(float * in_vertex, float * in_normal, Vector3 * out_vertex, Vector3 * out_normal) const;
    void BlendVerts(float power, float * in_vertex, float * in_normal, Vector3 * out_vertex, Vector3 * out_normal) const;
    void WriteBone(iqmgeom::Matrix3x4 * mtx, iqmjoint * joint, ModelBoneData * out) const;
};

#endif