#ifndef _DESS_GEOM_H
#define _DESS_GEOM_H

#include <dessint.h>
#include <math.h>
#include <glm/vec3.hpp>
#include <glm/vec2.hpp>
#include <glm/ext/quaternion_float.hpp>

#define PI 3.14159265358979323846f
const float DEG2RAD = PI / 180.0f;
const float RAD2DEG = 180.0f / PI;

typedef glm::vec2 Vector2;
typedef glm::vec3 Vector3;
typedef glm::quat Quat;
typedef glm::mat4 Matrix;

#define Vector3_UP  Vector3(0.0f, 1.0f, 0.0f)
#define Vector3_DOWN Vector3(0.0f, -1.0f, 0.0f)
#define Vector3_LEFT Vector3(-1.0f, 0.0f, 0.0f)
#define Vector3_RIGHT Vector3(1.0f, 0.0f, 0.0f)
#define Vector3_FORWARD Vector3(0.0f, 0.0f, 1.0f)
#define Vector3_BACK Vector3(0.0f, 0.0f, -1.0f)
#define Vector3_ZERO Vector3(0.0f, 0.0f, 0.0f)
#define Vector3_NORTH Vector3_BACK
#define Vector3_SOUTH Vector3_FORWARD
#define Vector3_WEST Vector3_LEFT
#define Vector3_EAST Vector3_RIGHT

#define Vector2_ZERO Vector2(0.0f, 0.0f)

#define Quat_IDENTITY Quat(1.0f, 0.0f, 0.0f, 0.0f)


#endif