#ifndef _DESS_TRANSFORM_H
#define _DESS_TRANSFORM_H

#include <dessgeom.h>

class Transform 
{
public:
    Transform();

    Transform & Rotate(Vector3 axis, float angle);
    Transform & Rotate(Quat rotation);
    Transform & LookAt(Vector3 target, Vector3 up = Vector3_UP);
    Transform & LookDirection(Vector3 direction, Vector3 up = Vector3_UP);
    Transform & Translate(Vector3 offset);
    Transform & SetPosition(Vector3 value);
    Transform & SetRotation(Quat rotation);
    Transform & SetScale(Vector3 value);
    Transform & SetScale(float value);
    Matrix GetMatrix() const;
    void SetMatrix(Matrix mtx);

    Vector3 Forwards() const;
    Vector3 Up() const;
    Vector3 Right() const;

    Vector3 position = Vector3_ZERO;
    Vector3 scale = Vector3(1.0f);
    Quat rotation = Quat_IDENTITY;
};

#endif