#include <Texture.h>
#include <SDL2/SDL_image.h>
#include <desslog.h>
#include <GL/glew.h>
#include <FileSystem.h>

u32 Texture::LoadTexture(const char * texturePath)
{
    std::string fullPath = FileSystem::GetAbsolutePath(texturePath);
    SDL_Surface * surface = IMG_Load(fullPath.c_str());
    if (surface == NULL)
    {
        Log_Error("Couldn't load texture %s\n", texturePath);
        return 0;
    }
    
    u8 bytesPerPixel = surface->format->BytesPerPixel;
    GLenum format = bytesPerPixel == 4 ? GL_RGBA : GL_BGR;

    if (bytesPerPixel == 4) 
    {
        if (surface->format->Rmask == 0x000000ff) 
        {
            format = GL_RGBA;
        } 
        else 
        {
            format = GL_BGRA;
        }
    } 
    else 
    {
        if (surface->format->Rmask == 0x000000ff) 
        {
            format = GL_RGB;
        } 
        else 
        {
            format = GL_BGR;
        }
    }

    u32 textureId;
	glGenTextures(1, &textureId);
	glBindTexture(GL_TEXTURE_2D, textureId);
    glTexImage2D(GL_TEXTURE_2D, 0, bytesPerPixel, surface->w, surface->h, 0, format, GL_UNSIGNED_BYTE, surface->pixels);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S , GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T , GL_REPEAT);
    
    SDL_FreeSurface(surface);
    return textureId;
}
