#ifndef _DESS_TEXTBOX_H
#define _DESS_TEXTBOX_H

#include <dessgeom.h>
#include <Entity.h>
#include <Mesh.h>
#include <MeshRenderer.h>

#define Textbox_MAX_TEXT_LENGTH 256

class Font;
class Material;

class Textbox : public Entity
{
private:
    Ref<Font> font;
    Ref<Material> material;
    MeshRenderer renderer;
    Mesh mesh;
    char text[Textbox_MAX_TEXT_LENGTH];
    Vector2 alignment = Vector2_ZERO;
    Vector3 color = Vector3(1.0f);
    u8 fontSize = 16;
    float maxWidth = 0.0f;
    float width = 0.0f;
    float height = 0.0f;
    bool isDirty;
    u16 textLength = 0;
    u16 maxDisplayLength = 0;

public:
    Textbox();
    virtual ~Textbox();

    virtual void Added();
    void SetFont(const char * pathPrefix);
    void SetText(const char * text);
    void Render();

    void SetAlignment(Vector2 value);
    void SetFontSize(u8 value);
    void SetMaxWidth(float value);
    void SetMaxDisplayLength(u16 value);
    void SetColor(Vector3 value);
    
    inline Vector3 GetColor() const { return color; }

    inline float GetWidth() const { return width; }
    inline float GetHeight() const { return height; }
    u16 GetTextLength();
    inline u16 GetMaxDisplayLength() const { return maxDisplayLength; }

private:
    void Redraw();
};

#endif