#ifndef _DESS_SPRITE_H
#define _DESS_SPRITE_H

#include <Entity.h>
#include <MeshRenderer.h>
#include <Mesh.h>
#include <Ref.h>

class Material;
class Mesh;

class Sprite : public Entity
{
private:
    Ref<Material> material;
    Mesh mesh;
    MeshRenderer renderer;
    bool isDirty = false;
    float rectTop = 0.0f;
    float rectRight = 1.0f;
    float rectBottom = 1.0f;
    float rectLeft = 0.0f;
    float width = 1.0f;
    float height = 1.0f;
    Vector3 alignment = Vector3(0.5f, 0.5f, 0.0f);
    Vector3 color = Vector3(1.0f);

public:
    Sprite();
    virtual ~Sprite();

    void Load(const char * texturePath);
    void Load(Ref<Material> & material);
    void Generate();
    void SetRect(float top, float right, float bottom, float left);
    void SetRect(u8 x, u8 y, u8 tilesX, u8 tilesY);
    void SetTile(u8 id, u8 tilesX, u8 tilesY);
    void ResetRect();
    void SetSize(float width, float height);
    void SetAlignment(Vector2 alignment);
    void SetColor(Vector3 color);

    void Render();

};

#endif