#include <Sprite.h>
#include <Material.h>
#include <Mesh.h>
#include <Maths.h>

Sprite::Sprite()
{
}

Sprite::~Sprite()
{
    Material::Free(material);
}

void Sprite::Load(const char * texturePath)
{
    Material::Free(material);
    material = Material::Load(texturePath, "shaders/ui.dsh");
    Generate();
}

void Sprite::Load(Ref<Material> & _material)
{
    Material::Free(material);
    material = Material::Get(_material);
    Generate();
}

void Sprite::Generate()
{
    mesh.SetMaterial(material);
    renderer.SetRenderSpace(RenderSpace_Screen);
    ResetRect();
}

void Sprite::SetRect(float top, float right, float bottom, float left)
{
    rectTop = top;
    rectRight = right;
    rectBottom = bottom;
    rectLeft = left;
    isDirty = true;
}

void Sprite::SetRect(u8 x, u8 y, u8 tilesX, u8 tilesY)
{
    float sizeX = 1.0f / (float)(tilesX > 0 ? tilesX : 1);
    float sizeY = 1.0f / (float)(tilesY > 0 ? tilesY : 1);
    SetRect(y * sizeY, (x + 1) * sizeX, (y + 1) * sizeY, x * sizeX);
}

void Sprite::SetTile(u8 index, u8 tilesX, u8 tilesY)
{
    if (tilesX < 1)
        tilesX = 1;
    if (tilesY < 1)
        tilesY = 1;
    SetRect(index % tilesX, index / tilesX, tilesX, tilesY);
}

void Sprite::ResetRect()
{
    SetRect(0.0f, 1.0f, 1.0f, 0.0f);
}

void Sprite::SetSize(float _width, float _height)
{
    width = _width;
    height = _height;
}

void Sprite::SetAlignment(Vector2 _alignment)
{
    alignment.x = Maths::Clamp01(_alignment.x);
    alignment.y = Maths::Clamp01(_alignment.y);
}

void Sprite::SetColor(Vector3 value)
{
    color = value;
    isDirty = true;
}

void Sprite::Render()
{
    if (isDirty)
    {
        mesh.ClearGeometry();
        mesh.SetVertexCount(4);
        mesh.SetIndexCount(6);
        mesh.vertices[0] = Vector3(0, 0, 0);
        mesh.vertices[1] = Vector3(1, 0, 0);
        mesh.vertices[2] = Vector3(1, 1, 0);
        mesh.vertices[3] = Vector3(0, 1, 0);
        mesh.indices[0] = 0;
        mesh.indices[1] = 1;
        mesh.indices[2] = 3;
        mesh.indices[3] = 1;
        mesh.indices[4] = 2;
        mesh.indices[5] = 3;
        mesh.uvs[0].x = rectLeft;
        mesh.uvs[0].y = rectTop;
        mesh.uvs[1].x = rectRight;
        mesh.uvs[1].y = rectTop;
        mesh.uvs[2].x = rectRight;
        mesh.uvs[2].y = rectBottom;
        mesh.uvs[3].x = rectLeft;
        mesh.uvs[3].y = rectBottom;
        mesh.colors.resize(4);
        mesh.colors[0] = color;
        mesh.colors[1] = color;
        mesh.colors[2] = color;
        mesh.colors[3] = color;
        isDirty = false;
    }
    Matrix mtx = transform.GetMatrix();
    mtx = glm::translate(mtx, -alignment);
    mtx = glm::scale(mtx, Vector3(width, height, 1.0f));
    renderer.Render(&mesh, mtx);
}