#ifndef _DESS_SOUND_PLAYER_H
#define _DESS_SOUND_PLAYER_H

#include <desslibs.h>
#include <desslist.h>
#include <Hash.h>
#include <SDL2/SDL_mixer.h>

#define SOUND_CHANNEL_COUNT 8

struct SoundFile
{
    HashInt hash = 0;
    Mix_Chunk * data = NULL;
    u32 lastPlayTick = 0;
};

enum SoundFlag
{
    SoundFlag_None,
    SoundFlag_No_Interupt = 1
};

class SoundPlayer
{
private:
    std::vector<SoundFile> files;
    
    SDL_AudioDeviceID deviceId = 0;
    u8 nextChannel = 0;

    SoundPlayer();
    SoundFile * GetFile(const char * path);

    bool isMuted;

    bool Init();

public:
    static SoundPlayer & Inst();

    void Play(const char * path, float volume = 1.0f, u16 flags = 0);
    void SetMuted(bool value);
    void Stop();
};

#endif