#ifndef _DESS_SHADER_H
#define _DESS_SHADER_H

#include <desstypes.h>
#include <map>

#define SHADER_INVALID_PARAMETER -1

struct ShaderPass
{
    u32 programId;
    u32 vertId;
    u32 fragId;
    i8 uniformSAMPLER = SHADER_INVALID_PARAMETER;
    i8 uniformMVP = SHADER_INVALID_PARAMETER;
    i8 uniformTIME = SHADER_INVALID_PARAMETER;
    u8 renderMode;
};

class Shader
{
public:
    static const Shader * LoadShader(const char * shaderPath);

    inline u8 GetPassCount() const { return (u8)passes.size(); }
    const ShaderPass * GetPass(u8 index) const;
    u32 GetProgram(u8 index) const;

private:
    std::vector<ShaderPass> passes;

    static bool LoadShaderPair(Shader * shader, const char * shaderPathPrefix, u32 existingProgramId = 0);
    static u32 LoadAndCompileShader(const char * filePath, u32 shaderType);
    static u32 CompileShader(const char * shaderCode, u32 shaderType);
    static u32 LinkShader(u32 vertId, u32 fragId, u32 existingProgramId = 0);

    static std::map<const char*, Shader> shaderCache;

    void LoadMultipass(const char * shaderPath);
};

#endif