#ifndef _SEQUENCER_H
#define _SEQUENCER_H

#include "dessint.h"

class Entity;

enum SequenceState
{
    SequenceState_INIT,
    SequenceState_RUNNING,
    SequenceState_PAUSED,
    SequenceState_COMPLETE,
    SequenceState_ABORTED
};

class Sequence
{
protected:
    SequenceState state = SequenceState_INIT;
public:
    virtual void Run() = 0;
    virtual void Stop() {}
    virtual void Resume() {}
    virtual bool CanContinue() { return false; }
    virtual Entity * GetTarget() const { return NULL; }

    friend class Sequencer;
};

class Sequencer
{
private:
    static Sequence * sequence;

public:
    static void Run(Sequence * _sequence);
    static bool IsRunning();
    static bool IsPaused();
    static bool HasCompleted();
    static void Stop();
    static void Resume();
    static void Tick();
    static Entity * GetTarget();
};

#endif 