#include <dessint.h>
#include "Sequencer.h"
#include "Entity.h"

Sequence * Sequencer::sequence = NULL;

void Sequencer::Run(Sequence * _sequence)
{
    Stop();
    sequence = _sequence;
    sequence->Run();
}

bool Sequencer::IsRunning()
{
    if (sequence == NULL)
        return false;
    return sequence->state >= SequenceState_RUNNING && sequence->state < SequenceState_COMPLETE;
}

bool Sequencer::HasCompleted()
{
    if (sequence == NULL)
        return false;
    return sequence->state >= SequenceState_COMPLETE;
}

bool Sequencer::IsPaused()
{
    if (sequence == NULL)
        return false;
    return sequence->state == SequenceState_PAUSED;
}

void Sequencer::Tick()
{
    if (sequence != NULL)
    {
        if (sequence->CanContinue())
        {
            sequence->Resume();
        }
    }
}

void Sequencer::Resume()
{
    if (sequence != NULL && sequence->state == SequenceState_PAUSED)
    {
        sequence->Resume();
    }
}

void Sequencer::Stop()
{
    if (sequence != NULL)
    {
        sequence->Stop();
        delete sequence;
        sequence = NULL;
    }
}

Entity * Sequencer::GetTarget()
{
    if (sequence != NULL)
        return sequence->GetTarget();
    return NULL;
}