#ifndef _DESS_SCENE_H
#define _DESS_SCENE_H

#include <desstypes.h>

class Entity;
class Game;

#define EntityIt std::vector<Entity*>::iterator

enum SceneState
{
    SceneState_Init,
    SceneState_Loaded,
    SceneState_Unloaded
};

class Scene
{
protected:
    SceneState state = SceneState_Init;
    std::vector<Entity*> entities;
    Game * game = NULL;
    
public:
    Scene();
    virtual ~Scene();

    virtual void AddEntity(Entity * entity);
    virtual void RemoveEntity(Entity * entity);
    Entity * GetEntity(u16 index) const;
    bool HasEntity(const Entity * entity) const;

    virtual void Init() {}
    virtual void Update(float dt);
    virtual void Render();

    virtual void OnUnload() {}

    Entity * GetNearestEntity(Vector3 position, u8 factionMask = 0, float distance = 100.0f);

    inline EntityIt EntitiesBegin() { return entities.begin(); }
    inline EntityIt EntitiesEnd() { return entities.end(); }
    inline u16 GetEntityCount() const { return (u16)entities.size(); }

    friend class Game;

private:
    std::vector<Entity*>::iterator FindEntity(Entity* entity);
    bool isUpdating = false;
};

#endif