#ifndef _DESS_REF_H
#define _DESS_REF_H

#include <Hash.h>

template <class T>
class Ref
{
protected:
    T * instance = NULL;
    HashInt hash = 0;

    static HashInt GetFreeHash()
    {
        static HashInt hash = 1;
        return hash++;
    }

public:
    Ref(T * instance = NULL, HashInt hash = 0) : instance(instance), hash(hash) 
    {
        if (hash == 0 && instance != NULL)
        {
            hash = GetFreeHash();
        }
    }

    inline const T * Inst() const { return instance; }
    inline const HashInt Hash() const { return hash; }
    inline bool IsValid() const { return instance != NULL; }
    const T * operator->() { return Inst(); }
    int operator==(T * x) { return x == instance ? 1 : 0; }
    int operator!=(T * x) { return x != instance ? 1 : 0; }
    int operator==(Ref<T> & x) { return x != NULL && x.instance == instance ? 1 : 0; }
    int operator!=(Ref<T> & x) { return x != NULL && x.instance != instance ? 1 : 0; }
};

template <class T>
Ref<T> & NoRef()
{
    static Ref<T> result(NULL);
    return result;
}

#endif