#include "Primatives.h"
#include "Mesh.h"

const float CUBE_VERTS[CUBE_VERTEX_COUNT] = {
    -0.5f,  -0.5f,  -0.5f,
     0.5f,  -0.5f,  -0.5f,
     0.5f,  -0.5f,   0.5f,
    -0.5f,  -0.5f,   0.5f,
    -0.5f,   0.5f,  -0.5f,
     0.5f,   0.5f,  -0.5f,
     0.5f,   0.5f,   0.5f,
    -0.5f,   0.5f,   0.5f
};

const u32 CUBE_INDICES[CUBE_INDEX_COUNT] = {
    0, 1, 3, 2, 1, 3,
    4, 5, 7, 6, 5, 7,
    4, 5, 0, 1, 5, 0,
    7, 6, 3, 2, 6, 3,
    4, 7, 0, 3, 7, 0,
    6, 5, 2, 1, 5, 2
};

void Primatives::Cube(Vector3 size, Vector3 center, float * vertices, u32 * indices)
{
    for (u16 i = 0; i < CUBE_VERTEX_COUNT; i += 3)
    {
        vertices[i] = center.x + size.x * CUBE_VERTS[i];
        vertices[i + 1] = center.y + size.y * CUBE_VERTS[i + 1];
        vertices[i + 2] = center.z + size.z * CUBE_VERTS[i + 2];
    }
    for (u16 i = 0; i < CUBE_INDEX_COUNT; i++)
    {
        indices[i] = CUBE_INDICES[i];
    }
}

void Primatives::Quad(Vector3 normal, Vector2 size, Mesh * mesh)
{
    Vector3 forward = -glm::cross(normal, Vector3_RIGHT);
    Vector3 right = glm::cross(normal, forward);
    mesh->SetVertexCount(4);
    mesh->SetIndexCount(6);
    mesh->vertices[0] = right * size.x * -0.5f + forward * size.y * -0.5f;
    mesh->vertices[1] = right * size.x * 0.5f + forward * size.y * -0.5f;
    mesh->vertices[2] = right * size.x * 0.5f + forward * size.y * 0.5f;
    mesh->vertices[3] = right * size.x * -0.5f + forward * size.y * 0.5f;
    mesh->uvs[0] = Vector2(0, 0);
    mesh->uvs[1] = Vector2(1, 0);
    mesh->uvs[2] = Vector2(1, 1);
    mesh->uvs[3] = Vector2(0, 1);
    mesh->normals[0] = normal;
    mesh->normals[1] = normal;
    mesh->normals[2] = normal;
    mesh->normals[3] = normal;
    mesh->indices[0] = 0;
    mesh->indices[1] = 1;
    mesh->indices[2] = 3;
    mesh->indices[3] = 1;
    mesh->indices[4] = 2;
    mesh->indices[5] = 3;
}