#ifndef _DESS_MODEL_READER_H
#define _DESS_MODEL_READER_H

#include "dessint.h"
#include "desslist.h"
#include <Transform.h>
#include <string.h>
#include <Hash.h>

class Mesh;

#define MODEL_NAME_LENGTH 16

struct ModelAnimData
{
    u16 frameFirst;
    u16 frameCount;
    bool loop = false;
    char name[MODEL_NAME_LENGTH];
};

struct ModelBoneData
{
    Transform transform;
    char name[MODEL_NAME_LENGTH];
};

class ModelReader
{
protected:
    std::vector<ModelAnimData> animations;
    std::vector<ModelBoneData> bones;
public:
    float scale = 1.0f;

    virtual bool Load(const char * modelPath) = 0;
    virtual void Clear() = 0;
    virtual void Process(Mesh * mesh, float * time, ModelAnimData * animA = NULL, ModelAnimData * animB = NULL, float blend = 0.0f) const = 0;
    virtual u16 GetFrameCount() const { return 0; }
    
    ModelAnimData * FindAnimation(const char * name) const
    {
        for (std::vector<ModelAnimData>::const_iterator it = animations.begin(); it != animations.end(); ++it)
        {
            if (HashEqual(it->name, name))
                return (ModelAnimData*)&(*it);
        }
        return NULL;
    }

    const ModelBoneData * FindBone(const char * name) const
    {
        for (std::vector<ModelBoneData>::const_iterator it = bones.begin(); it != bones.end(); ++it)
        {
            if (HashEqual(it->name, name))
                return &(*it);
        }
        return NULL;
    }
};

#endif