#ifndef _DESS_MODEL_3D_H
#define _DESS_MODEL_3D_H

#include <Mesh.h>
#include <Material.h>
#include <ModelReader.h>
#include <dessgeom.h>
#include <Transform.h>

const float MODEL_FPS_MULTIPLIER = 1.0f / 30.0f;

class MeshRenderer;

enum ModelFormat
{
    ModelFormat_NONE,
    ModelFormat_OBJ,
    ModelFormat_MD2,
    ModelFormat_IQM,
};

class Model3D
{
public:
    static ModelFormat GetModelFormat(const char * filePath);

    Mesh * mesh = NULL;
    MeshRenderer * renderer = NULL;
    Ref<ModelReader> reader;
    Ref<Material> material;
    ModelAnimData * animCurrent = NULL;
    ModelAnimData * animPrevious = NULL;
    ModelFormat format = ModelFormat_NONE;
    float blendDuration = 0.0f;
    float blendRemaining = 0.0f;
    bool isLoaded = false;
    Transform transform;
    Matrix mtxApplied;
    
public:
    float fps = 15.0f;
    float time = 0.0f;
    u16 animFirstFrame = 0;
    u16 animLastFrame = UINT16_MAX;
    bool animLoop = true;
    HashInt modelHash;

    Model3D();
    virtual ~Model3D();

    bool LoadModel(const char * modelPath, const char * animationPath, float scale = 1.0f);
    bool LoadModel(const char * modelPath, float scale = 1.0f);
    void Clear();
    void SetMaterial(Ref<Material> & material);
    void SetMaterial(const char * texturePath, const char * shaderPath = "shaders/standard.dsh");
    void BlendAnimation(ModelAnimData * animation, float blendTime);
    void BlendAnimation(ModelAnimData * animation, float blendTime, float fps);
    void PlayAnimation(ModelAnimData * animation, float time = 0.0f);
    void PlayAnimation(ModelAnimData * animation, float time, float fps);
    ModelAnimData * FindAnimation(const char * animName) const;
    const ModelBoneData * FindBone(const char * boneName) const;
    Matrix GetBonePose(const ModelBoneData * bone, bool scaled) const;
    void Update(float dt);
    void Render(MeshRenderer * renderer, Matrix matrix);
    void Render(Matrix matrix);
    inline const Mesh * GetMesh() const { return mesh; }
    inline bool IsLoaded() const { return isLoaded; }
};

#endif