#ifndef _DESS_MOD_MUSIC_PLAYER_H
#define _DESS_MOD_MUSIC_PLAYER_H

#include "dessint.h"
#include "desslist.h"
#include <Hash.h>

struct _ModPlugFile;
struct SDL_AudioSpec;

struct ModMusicCue
{
    HashInt hash = 0;
    HashInt fileHash = 0;
    u16 start = 0;
    u16 end = 0;
    u16 repeat = 0;
    u16 bpm = 170;
    bool persistant = false;
};

struct ModMusicFile
{
    HashInt hash = 0;
    SDL_AudioSpec * spec = NULL;
    _ModPlugFile * mod = NULL;
    u32 deviceId = 0;
};

enum ModMusicTrackIndex
{
    MusicTrack_Main,
    MusicTrack_Override,
    MusicTrack_COUNT
};

class ModMusicTrack
{
public:
    u32 position = 0;
    u16 pattern = 0;
    u16 beat = 0;
    ModMusicCue cue;
    ModMusicFile * file = NULL;
};

#define PATTERN_NONE UINT8_MAX

class ModMusicPlayer
{
public:
    static ModMusicPlayer * Current();

    ModMusicPlayer();
    virtual ~ModMusicPlayer();

protected:
    static ModMusicPlayer * current;
    static void AudioCallback(void * userdata, u8 * stream, int len);

    bool Init();

    ModMusicTrack tracks[MusicTrack_COUNT];
    bool isPlaying = false;

    std::vector<ModMusicFile> files;
    std::vector<ModMusicCue> cues;
    float pauseTime = 0.0;
    u8 pausePos = 0;
    u32 deviceId = 0;

    void UpdateAudio(u8 * stream, int len);

    bool LoadCueToTrack(ModMusicTrackIndex track, const ModMusicCue * cue);
    bool SetFile(ModMusicTrackIndex track, const char * filePath);
    bool SetFile(ModMusicTrackIndex track, HashInt hash);

    bool isMuted = false;

public:
    bool PlayPatterns(u16 patternStart = 0, u16 patternEnd = 0, u16 patternRepeat = 0);
    virtual bool Play(const char * cueName);
    bool Play(const ModMusicCue * cue);
    bool PlayOverride(const ModMusicCue * cue);

    ModMusicFile * LoadMod(const char * path);

    const ModMusicCue * GetCue(const char * save);
    const ModMusicCue * GetCue(HashInt saveHash);
    bool HasCue(const char * save) const;
    bool HasCue(HashInt saveHash) const;

    virtual void Resume();

    void Update(float dt);

    void Pause();

    void PauseFor(float time);

    bool IsContinuous(ModMusicTrackIndex track, const ModMusicCue * cue) const;

    bool IsPersistant() const;

    void Stop();
    void StopOverride();

    void Unload();

    HashInt GetCue() const;
    u16 GetPattern() const;

    inline bool IsPlaying() const { return isPlaying; }

    void SetMuted(bool value);
};

#endif