#ifndef _DESS_MESH_RENDERER_H
#define _DESS_MESH_RENDERER_H

#include <desstypes.h>

enum RenderBuffer {
    RenderBuffer_VERTEX,
    RenderBuffer_UV,
    RenderBuffer_NORMAL,
    RenderBuffer_COLOR,
    RenderBuffer_INDEX,
    RenderBuffer_MAX
};

enum RenderSpace {
    RenderSpace_World,
    RenderSpace_Screen
};

class Mesh;

class MeshRenderer
{
private:
    RenderSpace renderSpace = RenderSpace_World;
    u32 buffers[RenderBuffer_MAX];
    u32 bufferSizes[RenderBuffer_MAX];

public:
    MeshRenderer();
    virtual ~MeshRenderer();

    void SetRenderSpace(RenderSpace _renderSpace);

    void Render(const Mesh * mesh, const Matrix * matrix);
    void Render(const Mesh * mesh, const Matrix matrix);

    inline RenderSpace GetRenderSpace() const { return renderSpace; }

private:
    Matrix mtxModel;
    const Mesh * mesh = NULL;
    u32 matrixId = 0;

    void SetMesh(const Mesh * newMesh);

    void ClearBuffers();
    void SetBuffer(u32 glBufferType, RenderBuffer renderBuffer, u32 bufferSize, void * data);

    void Render_Internal();
};

#endif