#ifndef _DESS_MESH_H
#define _DESS_MESH_H

#include <dessgeom.h>
#include <Material.h>
#include <Ref.h>

class Mesh
{
public:
    static u32 ClampBuffer(size_t n);

    Ref<Material> material;
    std::vector<Vector3> vertices;
    std::vector<Vector2> uvs;
    std::vector<Vector3> colors;
    std::vector<Vector3> normals;
    std::vector<u32> indices;

    Mesh();
    Mesh(const Mesh& mesh);
    virtual ~Mesh();

    void Clear();
    void ClearGeometry();

    void Copy(const Mesh * other);

    void SetMaterial(Ref<Material> & value);
    void SetMaterial(Material * value);

    void AddVertices(Vector3 * arr, u32 count);
    void AddVertices(std::vector<Vector3> & source);

    void AddUvs(Vector2 * arr, u32 count);
    void AddUvs(std::vector<Vector2> & source);

    void AddNormals(Vector3 * arr, u32 count);
    void AddNormals(std::vector<Vector3> & source);

    void AddColors(Vector3 * arr, u32 count);
    void AddColors(std::vector<Vector3> & source);

    void AddIndices(u32 * arr, u32 count);
    void AddIndices(std::vector<u32> & indices);

    void AddTriangleFan(std::vector<Vector3> & _vertices, std::vector<Vector2> & _uvs, std::vector<Vector3> & _normals);
    void AddTriangleFan(std::vector<Vector3> & _vertices);

    void SetVertexCount(u16 count);
    void SetIndexCount(u16 count);
    
    inline const Ref<Material> & GetMaterial() const { return material; }
    inline const std::vector<Vector3> & GetVertices() const { return vertices; }
    inline const std::vector<Vector2> & GetUvs() const { return uvs; }
    inline const std::vector<Vector3> & GetNormals() const { return normals; }
    inline const std::vector<Vector3> & GetColors() const { return colors; }
    inline const std::vector<u32> & GetIndices() const { return indices; }
    inline const u16 GetVertexCount() const { return (u16)vertices.size(); }
    inline const u16 GetIndexCount() const { return (u16)indices.size(); }
};

#endif