#ifndef _DESS_MATERIAL_H
#define _DESS_MATERIAL_H

#include <desstypes.h>
#include <Hash.h>
#include <Ref.h>

#define MATERIAL_DEFAULT_PATH "mats/standard.dsh"

class Shader;
struct ShaderPass;

class Material
{
private:
    HashInt hash = 0;
    HashInt shaderHash = 0;
    HashInt textureHash = 0;
    Vector3 color = Vector3(1.0f, 1.0f, 1.0f);
    u8 userCount = 0;
    u16 managerId = 0;

public:
    static Ref<Material> & Load(const char * texturePath, const char * shaderPathPrefix = MATERIAL_DEFAULT_PATH);
    static Ref<Material> & Get(const Ref<Material> & material);
    static Ref<Material> & Clone(const Ref<Material> & material);
    static void Free(Ref<Material> & material);

    Material();
    Material(const Material * original);

    void Copy(const Material * original);

    const Shader * shader = NULL;
    u32 textureId = 0;
    void * owner = NULL;
    
    void LoadShader(const char * shaderPathPrefix);
    void SetShader(const Shader * shader);
    void LoadTexture(const char * texturePath, const char * shaderPathPrefix = NULL);

    void SetColor(Vector3 value) { color = value; }
    inline Vector3 GetColor() const { return color; }

    const ShaderPass * Use(u8 pass = 0) const;
};

#endif