#include <Hash.h>

const HashInt Hash(const char * str)
{
    if (str == NULL || str[0] == '\0')
        return 0;

    HashInt hash = 5381;
    HashInt c = 0;

    while (c = *str++)
    {
        if (c >= 'a' && c <= 'z')
        {
            c = c + 'A' - 'a';
        }
        if (c == ' ' || c == '\t' || c == '\n' || c == '\r')
        {
            continue;
        }
        if ((c >= '0' && c <= '9') == false && (c >= 'A' && c <= 'Z') == false)
        {
            c = '_';
        }
        hash = ((hash << 3) + hash) + c;
    }

    return hash;
}

bool HashEqual(const char * a, const char * b)
{
    return Hash(a) == Hash(b);
}