#ifndef _DESS_GAME_H
#define _DESS_GAME_H

#include <RenderWindow.h>
#include <string>

class Scene;
class Input;

class Game
{
public:
    Game(const char * name);
    bool Tick();
    virtual void Update(float dt) {}
    void Stop();

    virtual void SetScene(Scene * scene);
    Scene * GetScene();
    virtual void OnLoadScene(Scene * scene) {}
    virtual void OnUnloadScene(Scene * scene) {}

protected:
    std::string name;
    bool isRunning;
    RenderWindow renderWindow;
    Scene * scene = NULL;
    Scene * pendingScene = NULL;
    u32 frameTick = 0;
};


#endif