#ifndef _DESS_FONT_H
#define _DESS_FONT_H

#include <desstypes.h>
#include <Ref.h>

class Material;

struct FontChar
{
    u16 x = 0;
    u16 y = 0;
    u16 w = 0;
    u16 h = 0;
    i16 offX = 0;
    i16 offY = 0;
    i16 addX = 0;
};

struct FontProps
{
    u8 size = 1;
    u8 lineHeight = 1;
    u8 textureWidth = 1;
    u8 textureHeight = 1;
};

class Font
{
private:    
    FontChar chars[128];
    Ref<Material> material;
public:
    Font();
    virtual ~Font();

    FontProps props;

    static Ref<Font> & Load(const char * name);

    const FontChar * GetChar(char c) const;
    inline const Ref<Material> & GetMaterial() const { return material; }
};

#endif