#ifndef _DESS_FILESYSTEM_H
#define _DESS_FILESYSTEM_H

#include <desstypes.h>
#include <string>

class Mesh;
namespace tinyxml2 {
    class XMLDocument;
}
struct SDL_RWops;

struct DirScan
{
    void * dir = NULL;
};

class FileSystem
{
public:
    
    static std::string GetBaseName(const char * path, bool includeExtension = false);
    static std::string GetExtension(const char * path);
    static std::string CombinePath(const char * a, const char * b);
    static std::string SanitisePath(const char * a);
    static std::string GetAbsolutePath(const char * path);
    static std::string GetPrefPath(const char * path);
    static bool IsExtenstion(const char * path, const char * ext);
    static bool IsAbsolutePath(const char * path);

    static SDL_RWops * FileOpen(const char * path, const char* mode);
    static size_t FileRead(SDL_RWops * file, void* ptr, size_t size, size_t maxnum);
    static size_t FileWrite(SDL_RWops * file, void* ptr, size_t size, size_t maxnum);
    static void FileClose(SDL_RWops * file);

    static std::string LoadText(const char * path); 
    static void LoadXML(const char * path, tinyxml2::XMLDocument * doc);

    static DirScan DirOpen(const char * path);
    static const char * DirRead(DirScan & dir);
};

#endif