#ifndef _DESS_ENTITY_H
#define _DESS_ENTITY_H

#include <Transform.h>

class Scene;
class Renderer;
class Collider;

enum EntityState
{
    ENTITY_STATE_INIT,
    ENTITY_STATE_ADDED,
    ENTITY_STATE_ENABLED,
    ENTITY_STATE_DISABLED,
    ENTITY_STATE_REMOVED,
    ENTITY_STATE_DESTROYING
};

class Entity
{
public:
    static bool IsActive(const Entity * entity);
    static bool NotDestroyed(const Entity * entity);

    i16 renderQueue = 0;
    bool isVisible = true;

    Entity();
    virtual ~Entity();
    
    virtual void Added() {}
    virtual void Start() {}
    virtual void OnEnabled() {}
    virtual void Update(float dt) {}
    virtual void Render() {}
    virtual void OnDisabled() {}
    virtual void Removed() {}
    virtual void Remove();
    virtual void Destroy();
    
    friend class Scene;

    Transform transform;
    Collider * collider = NULL;
    const char * name = NULL;

    virtual void OnCollision(Entity * other) {}
    Scene * scene = NULL;
    void * entityOwner = NULL;

    void SetEnabled(bool on);
    inline void SetVisible(bool on) { isVisible = on; }

    inline bool IsAdded() const { return state >= ENTITY_STATE_ENABLED && state <= ENTITY_STATE_DISABLED; }
    inline bool IsEnabled() const { return state < ENTITY_STATE_DISABLED; }
    inline bool IsDisabled() const { return state >= ENTITY_STATE_DISABLED; }
    inline bool IsVisible() const { return isVisible; }
    inline bool UseCulling() const { return useCulling; }
    inline u8 GetFaction() const { return faction; }
    void SetFaction(u8 value) { faction = value; }
    void SetCulling(bool on) { useCulling = on; }

protected:
    EntityState state = ENTITY_STATE_INIT;
    u8 faction = 0;
    u16 type = 0;
    bool useCulling = true;
};

#endif