#include <Entity.h>
#include <Scene.h>
#include <Collider.h>

Entity::Entity()
{
}

Entity::~Entity()
{
    if (collider != NULL && collider->owner == this)
    {
        delete collider;
    }
    collider = NULL;
}

bool Entity::IsActive(const Entity * entity)
{
    return entity != NULL && entity->state == ENTITY_STATE_ENABLED && entity->scene != NULL;
}

bool Entity::NotDestroyed(const Entity * entity)
{
    return entity != NULL && entity->state < ENTITY_STATE_DESTROYING && entity->scene != NULL;
}

void Entity::Remove()
{
    if (scene != NULL)
    {
        scene->RemoveEntity(this);
    }
}

void Entity::SetEnabled(bool on)
{
    if (on && state == ENTITY_STATE_DISABLED)
    {
        state = ENTITY_STATE_ENABLED;
        OnEnabled();
    }
    else if (on == false)
    {
        bool needsDisable = state == ENTITY_STATE_ENABLED;
        state = ENTITY_STATE_DISABLED;
        if (needsDisable)
        {
            OnDisabled();
        }
    }
}

void Entity::Destroy()
{
    state = ENTITY_STATE_DESTROYING;
    Remove();
    delete this;
}