#include <CollisionChecker.h>
#include <Scene.h>
#include <Entity.h>
#include <desstypes.h>
#include <Collider.h>

CollisionChecker * CollisionChecker::current = NULL;

CollisionChecker::CollisionChecker()
{
    current = this;
}

CollisionChecker::~CollisionChecker()
{
    if (current == this)
    {
        current = NULL;
    }
}

CollisionChecker * CollisionChecker::Current()
{
    return current;
}

void CollisionChecker::Clear()
{
    collisions.clear();
}

void CollisionChecker::Check(Scene * scene)
{
    currentScene = scene;

    for (EntityIt a = scene->EntitiesBegin(); a != scene->EntitiesEnd(); ++a)
    {
        if ((*a)->collider == NULL)
            continue;

        (*a)->collider->collisions.clear();
    }

    u16 entityCount = scene->GetEntityCount();
    if (entityCount < 2)
        return;

    Entity *a, *b;
    u16 ia, ib;
    Collider *ca, *cb;
    for (ia = 0; ia < entityCount; ia++)
    {
        a = scene->GetEntity(ia);
        if (a == NULL || a->collider == NULL || a->IsEnabled() == false || a->collider->mode == CollisionMode_None)
            continue;

        ca = a->collider;
        ca->collisions.clear();
        
        for (ib = ia + 1; ib < entityCount; ib++)
        {
            b = scene->GetEntity(ib);
            if (a == b || b == NULL || b->collider == NULL || b->IsEnabled() == false || b->collider->mode == CollisionMode_None)
                continue;

            cb = b->collider;

            if (ca->mode < CollisionMode_Collide && cb->mode < CollisionMode_Collide)
                continue;

            if (cb->CollidesWith(ca))
            {
                ca->collisions.push_back(b);
                cb->collisions.push_back(a);
                
                if (ca->mode >= CollisionMode_Resolve && cb->mode >= CollisionMode_Collide) 
                {
                    ca->Resolve(cb);
                }

                if (cb->mode >= CollisionMode_Resolve && ca->mode >= CollisionMode_Collide) 
                {
                    cb->Resolve(ca);
                }
                
                ca->owner->OnCollision(b);
                cb->owner->OnCollision(a);
            }
        }
    }
}

Entity * CollisionChecker::CheckPoint(Vector3 p) const
{
    if (currentScene != NULL)
    {
        Entity * a;
        for (u16 i = 0; i < currentScene->GetEntityCount(); i++)
        {
            a = currentScene->GetEntity(i);
            if (a == NULL || a->collider == NULL || a->IsEnabled() == false || a->collider->mode == CollisionMode_None)
                continue;

            if (a->collider->Overlaps(p))
                return a;
        }
    }
    return NULL;
}