#ifndef _DESS_COLLIDER_H
#define _DESS_COLLIDER_H

#include <desstypes.h>

class Entity;

enum CollisionMode {
    CollisionMode_Init,
    CollisionMode_None,
    CollisionMode_Receive,
    CollisionMode_Collide,
    CollisionMode_Resolve
};

struct AABB {
    Vector3 pos = Vector3_ZERO;
    Vector3 half = Vector3(1.0f);
    bool Overlaps(const AABB & other) const;
    bool Overlaps(Vector3 p) const;
    void Resolve(const AABB & other);
};

class Entity;

class Collider
{
public:
    Entity * owner = NULL;
    CollisionMode mode = CollisionMode_Init;
    u16 type = 0;
    float mass = 1.0f;
    AABB aabb;
    Vector3 size = Vector3(1.0f);
    Vector3 center = Vector3_ZERO;
    std::vector<Entity*> collisions;

    const AABB & GetAABB();

    Collider(Entity * owner, Vector3 size, Vector3 center = Vector3(0));

    virtual bool CollidesWith(Collider * other);
    virtual bool Overlaps(Vector3 p);
    virtual void Resolve(Collider * other);
};

#endif