#ifndef _DESS_CAMERA_H
#define _DESS_CAMERA_H

#include <desstypes.h>
#include <Transform.h>

class Camera
{
private:
    static Camera * initial;
    static Camera * current;

    float shakePower = 0.0f;
    Vector3 shakeOffset = Vector3_ZERO;

public:
    static Camera * Current();

    u32 fov = 45;
    Vector3 backgroundColor = Vector3_ZERO;
    Transform transform;

    Camera();
    virtual ~Camera();

    void SetCurrent();

    void Shake(float power);

    virtual void Update(float dt);

    Matrix GetViewMatrix();
};

#endif