#include <Camera.h>
#include <Maths.h>
#include <glm/gtc/matrix_transform.hpp>
#include <glm/gtx/quaternion.hpp>

Camera *Camera::initial = NULL;
Camera *Camera::current = NULL;

Camera * Camera::Current()
{
    if (initial == NULL)
    {
        if (current != NULL)
        {
            initial = current;
        }
        else
        {
            initial = new Camera();
            current = initial;
        }
    }
    return current;
}

Camera::Camera() :
    backgroundColor(0.0f, 0.0f, 0.0f)
{
    if (current == NULL)
    {
        SetCurrent();
    }
}

Camera::~Camera()
{
    if (current == this)
    {
        current = NULL;
    }
}

void Camera::Shake(float power)
{
    shakePower = power * 0.5f;
}

void Camera::Update(float dt)
{
    if (shakePower > 0.1f)
    {
        shakeOffset = Vector3(
            Maths::RandF(-shakePower, shakePower),
            Maths::RandF(-shakePower, shakePower),
            0.0f
        );
        shakePower *= 1.0f - Maths::DeltaEase(0.1f, dt);
    }
}

void Camera::SetCurrent()
{
    current = this;
}

Matrix Camera::GetViewMatrix()
{
    Matrix mtx = glm::mat4_cast(glm::inverse(transform.rotation));
    mtx = glm::translate(mtx, transform.position * -1.0f);
    mtx = glm::translate(mtx, shakeOffset);
    return mtx;
}