#ifndef _DESS_CACHE_H
#define _DESS_CACHE_H

#include <desstypes.h>
#include <map>
#include <Hash.h>
#include <Ref.h>

template <class T>
class CacheMap
{
public:
    class CacheRef : public Ref<T>
    {
    public:
        i16 users = 0;
        CacheRef(T * instance = NULL, HashInt hash = 0) : Ref<T>(instance, hash) {}
        void Clear()
        {
            Ref<T>::instance = NULL;
        }
    };
    typedef std::map<HashInt, CacheRef> RefMap;

private:
    RefMap refMap;

public:
    CacheMap(){}
    virtual ~CacheMap()
    {
        refMap.clear();
    }

    Ref<T> & Get(const char * path)
    {
        return Get(Hash(path));
    }

    Ref<T> & Get(HashInt hash)
    {
        typename RefMap::iterator found = refMap.find(hash);
        if (found != refMap.end())
        {
            found->second.users++;
            return found->second;
        }
        return NoRef<T>();
    }

    Ref<T> & Get(const Ref<T> & ref)
    {
        return Get(ref.Hash());
    }

    Ref<T> & Create(const char * path)
    {
        return Create(Hash(path));
    }

    Ref<T> & Create(HashInt hash)
    {
        Set(hash, T());
        return Get(hash);
    }

    void Set(const char * path, T * instance)
    {
        Set(Hash(path), instance);
    }

    void Set(HashInt hash, T * instance)
    {
        typename RefMap::iterator found = refMap.find(hash);
        if (found != refMap.end())
        {
            Log_Error("Cache replace not allowed!");
            return;
        }
        refMap[hash] = CacheRef(instance, hash);
    }

    HashInt GetNextFreeHash(const Ref<T> & ref)
    {
        return GetNextFreeHash(ref.Hash());
    }

    HashInt GetNextFreeHash(HashInt hash)
    {
        hash = hash + 1;
        typename RefMap::iterator found;
        while (true)
        {
            found = refMap.find(hash);
            if (found == refMap.end())
            {
                return hash;
            }
            hash++;
        }
        return hash;
    }

    bool Free(Ref<T> & ref)
    {
        HashInt hash = ref.Hash();
        if (hash == 0 || ref.IsValid() == false)
            return false;

        typename RefMap::iterator found = refMap.find(hash);
        if (found != refMap.end())
        {
            if (found->second.users > 0)
            {
                found->second.users--;
            }
            if (found->second.users < 1)
            {
                if (found->second.users < 0)
                {
                    Log_Error("Negative users.");
                }
                else
                {
                    /*
                    T * inst = (T*)found->second.Inst();
                    if (inst != NULL)
                    {
                        delete inst;
                    }
                    refMap.erase(found);
                    */
                }
            }
            //found->second.Clear();
            return true;
        }
        Log_Info("Unmanaged instance\n");
        return false;
    }

};

template <class T> 
CacheMap<T> & GetCache()
{
    static CacheMap<T> cache;
    return cache;
}

#endif
