#version 330 core

layout(location = 0) in vec3 vertexPosition_modelspace;
layout(location = 1) in vec2 vertexUV;

out vec2 UV;
out float VY;

uniform mat4 MVP;
uniform float TIME;

void main()
{
	vec4 pos = MVP * vec4(vertexPosition_modelspace, 1);
	gl_Position = pos;

	VY = vertexPosition_modelspace.y;
	UV.x = vertexUV.x + (sin(TIME) * 0.15 + cos((vertexPosition_modelspace.x + TIME) * 0.63) * 0.071) * 0.5;
	UV.y = vertexUV.y + (cos(TIME) * 0.15 + sin((vertexPosition_modelspace.z + vertexPosition_modelspace.z + TIME) * 1.31) * 0.071) * 0.5;
}
