#version 330 core

in vec2 UV;

out vec4 color;

uniform sampler2D renderedTexture;
uniform float time;
uniform vec2 resolution = vec2(600.0, 360.0);

void main()
{
	vec2 uv = UV;
	uv *= resolution;
	uv = floor(uv) + 0.5 + 1.0 - clamp(1.0 - fract(uv), 0.0, 1.0);
	uv /= resolution;
	color.xyz = texture(renderedTexture, uv).xyz;
	color.a = 1.0;
}