#version 330 core

in vec2 UV;

out vec4 color;

uniform sampler2D renderedTexture;
uniform float time;

void main()
{
	vec3 incolor = texture(renderedTexture, UV).xyz;
    float grey = (incolor.r + incolor.g + incolor.b) * 0.333;
    color.r = grey;
    color.g = grey;
    color.b = (grey * grey * 0.9) + (grey * 0.1);
    color.rgb = color.rgb * 0.8 + incolor.rgb * 0.2;
    color *= clamp(0.9 - ((0.5 - UV.x) * (0.5 - UV.x) + (0.5 - UV.y) * (0.5 - UV.y)), 0.0, 1.0);
    color.rgb = clamp(color.rgb + incolor * clamp(grey - 0.95, 0.0, 0.05) * 20.0, 0.0, 1.0);
	color.a = 1.0;
}